************************************************************************
* Project Build routine
****************************************
***  Function: Builds EXE, configures DCOM and optionally uploads
***            
***    Assume:
***      Pass:
***    Return:
************************************************************************
LPARAMETER lcExe,lcClassId, lcUserName, llRegOnly, llCopyToServer
LOCAL lcFile, lcTemplate, lcOLEFlag, lcNewFile

#INCLUDE WCONNECT.H

*** You can run this to auto update your server using the
*** _maintain~UpdateExe functionality to hot swap COM servers
*** These defines are optional and only apply if you use
*** the llCopyServer flag above.

*** Set these if you want to FTP file to a server 
*** This should go where UpdateExe= in wc.ini points to
#DEFINE FTP_SERVER           ""           && "ftp.xxx.com"
#DEFINE FTP_PATH             ""           && "/uploads/Memberlistapp.exe"


*** URL to hot swap COM exe's - make sure your server was registered 
*** at least once before running the autoupdate features
#DEFINE HTTP_UPDATEURL ""       && "http://www.xxx.com/wconnect/wc.dll?_maintain~UpdateExe"

SET PROCEDURE TO wwUtils additive

lcExe=IIF(type("lcExe")="C",justfname(lcExe),"Memberlistapp")
lcClassId=IIF(type("lcClassId")="C",lcClassId,"Memberlistapp.MemberlistappServer")
lcUserName=IIF(type("lcUserName")="C",lcUserName,"Interactive User")

*** Make sure classes is in the path
DO PATH WITH ".\classes"

SET PROCEDURE TO 
SET CLASSLIB TO

IF !llRegOnly
  BUILD EXE (lcEXE) FROM (lcExe) recompile
ENDIF

*** Released during build
SET PROCEDURE TO WWUTILS 
SET PROCEDURE TO WWAPI ADDITIVE

IF FILE("Memberlistapp.err")
   MODIFY COMMAND wcDemo.err
   RETURN
ENDIF

DO DCOMCnfgServer with lcClassId, lcUsername

IF llCopyToServer AND !EMPTY(FTP_SERVER)
   SET CLASSLIB TO wwIPSTUFF ADDIT
   SET PROCEDURE TO wwUtils ADDIT
   oIP = CREATEOBJECT("wwIPStuff")
   oFTP = CREATEOBJECT("wwFTP")

   wait window nowait "Copying file to server..." 

   *** You can replace the FTP stuff with a plain path if the
   *** server is directly accessible to you
   * COPY FILE (lcEXE + ".exe" ) TO "f:\temp\server\" + lcExe + ".exe"
   
   lcUserName = InputForm(SPACE(20),"Enter your Server Username:","Upload Exe")
   lcPassword = InputForm(SPACE(20),"Enter your Server Password:","Upload Exe")

   IF oFTP.FTPSendFile(FTP_SERVER,SYS(5) + CURDIR() + lcExe + ".exe",FTP_PATH,lcUserName,lcPassword) # 0
      MESSAGEBOX("Error Uploading File" + oFTP.cErrorMsg)
      RETURN
   ENDIF
   
   lcURL = InputForm(PADR(HTTP_UPDATEURL,100),"URL to update Exe","Update")
   
   wait window nowait "Updating Exe File on Web Server..."
   lcHTML = oIP.HTTPGet(lcUrl,lcUserName, lcPassword)
   
   wait clear
   IF !"Exe Updated" $ lcHTML
      ShowHTML(lchTML)
   ELSE
      MESSAGEBOX("Update completed",64,"Code update")
   ENDIF
ENDIF
