************************************************************************
*FUNCTION MemberlistappMain
******************************
***   Created: 06/29/02
***  Function: Web Connection Mainline program. Responsible for setting
***            up the Web Connection Server and get it ready to
***            receive requests in file messaging mode.
************************************************************************

*** This is the file based start up code that gets
*** the server form up and running
#INCLUDE WCONNECT.H 

*** PUBLIC flag allows server to never quit 
*** - unless EXIT button code is executed
RELEASE goWCServer

SET TALK OFF
SET NOTIFY OFF

   #IF !DEBUGMODE
     SET DEBUG OFF
     SET STATUS BAR OFF
     SET DEVELOP OFF
     SET SYSMENU OFF
   #ENDIF

   *** Allow shut down by system
   ON SHUTDOWN DO ShutIt IN MemberlistappMain.PRG

   *** Load the Web Connection class libraries
   DO WCONNECT

   *** Load the server - wc3DemoServer class below
   goWCServer = CREATE("MemberlistappServer")
                    
   IF TYPE("goWCServer")#"O"
      =MessageBox("Unable to load Web Connection Server",48,;
                  "Web Connection Error")
      RETURN
   ENDIF
   
   *** Make the server live - Show puts the server online and in polling mode
   READ EVENTS
   
   *** Done
   ON SHUTDOWN

ON ERROR
RELEASE goWCServer

SET SYSMENU ON
SET DEBUG ON
SET DEVELOP ON
SET STATUS BAR ON
SET TALK ON

RETURN


**************************************************************
****          YOUR SERVER CLASS DEFINITION                 ***
**************************************************************
DEFINE CLASS MemberlistappServer AS WWC_SERVER OLEPUBLIC
*************************************************************
***  Function: This is a subclass of the wwServer class
***            that is application specific. Each Web Connection
***            server you create *MUST* create a subclass of the
***            class and at least implement the Process and
***            SetServerEnvironment methods to  receive requests!
*************************************************************

*** Add any custom properties here
*** These can act as 'global' vars 
oMember = .NULL.
oPhones = .NULL.

************************************************************************
* MemberlistappServer :: SetServerEnvironment
******************************************
***  Function: This method sets the server's environment in terms
***            of VFP Environment settings. This code executes
***            just prior to the Init Code of the base class. Any
***            SET or ON statements should be made here.
***
***            THIS.cAppStartPath returns your application's startup
***            path as stored in the registry. If you need to override
***            this path in code you should do so here. This value
***            is used to SET DEFAULT TO in the Init(). You can
***            set this value on the WC Status form's Startup Path.
***
***    Assume: VIRTUAL METHOD - must ALWAYS be implemented!!!
************************************************************************
PROTECTED FUNCTION SetServerEnvironment

*** Location of the startup INI file 
THIS.cAppIniFile = addbs(THIS.cAppStartPath) + "Memberlistapp.ini"
THIS.cAppName = "Memberlistapp"

#IF !DEBUGMODE
   *** Backup Error handler only - startup code and a few file access errors
   ***                             are the only things handled by this one
   ON ERROR DO ErrorHandler WITH ;
              ERROR(),MESSAGE(),MESSAGE(1),SYS(16),LINENO() ;
              IN MemberlistappMain.PRG
#ENDIF

*** Custom Server Configuration object - created at bottom
*** wwServer::ReadConfiguration will read settings from INI
THIS.oConfig = CREATEOBJECT("MemberlistappConfig")
THIS.oConfig.cFileName = THIS.cAppIniFile

ENDFUNC
* SetServerEnvironment


************************************************************************
* MemberlistappServer :: SetServerProperties
****************************************
***  Function: This Method should be used to set any server properties
***            and any relative paths. At this time the server has
***            changed directories to its startup path, so it's safe
***            to set relative paths from here.
***
***            This code runs just prior to showing the server window.
************************************************************************
PROTECTED FUNCTION SetServerProperties

*** This URL is executed when clicking on the Automation Server
*** Form's Exit button. It forces operation through a browser!
THIS.cCOMReleaseUrl=THIS.oConfig.cComReleaseUrl

*** Any settings you want to make to the server
IF THIS.lShowServerForm
  THIS.oServerForm.Caption =This.cServerId + " - Web Connection " + WWVERSION 
ENDIF  

*** Add persistent SQL Server Connection 
#IF WWC_USE_SQL_SYSTEMFILES
    THIS.AddProperty("oSQL", CREATE("wwSQL"))
    IF !THIS.oSQL.Connect(THIS.oConfig.cSQLConnectString)
	   MESSAGEBOX("Couldn't connect to SQL Service. Check your SQL Connect string in the INI file.",48,"Web Connection")
	   CANCEL
    ENDIF
#ENDIF	

*** Add any data paths - SET DEFAULT has already occurred so this is safe!

*** Add any SET CLASSLIB or SET PROCEDURE code here
SET CLASSLIB TO AFUGBusiness ADDITIVE
SET CLASSLIB TO MemberList_Work ADDITIVE
THIS.oMember = CREATEOBJECT("AFUG_Member")
THIS.oPhones = CREATEOBJECT("AFUG_Phones")

ENDFUNC
* SetServerProperties


************************************************************************
* MemberlistappServer :: Process
******************************
***  Function: This procedure's main purpose is to route incoming
***            requests to individual project PRGs/APPs.
***
***            The URL formatting used is as follows:
***            /wconnect/wc.dll?project~ClassMethod~Parm1~Parm2 etc.
***
***            The project 'parameter' is routed to the appropriate
***            program file which actually implements a Process class
***            to respond to requests. ClassMethod calls the method
***            in the wwProcess class implemented in project.prg
************************************************************************
PROTECTED FUNCTION Process
LOCAL lcParameter, lcExtension, lcPhysicalPath

*** Retrieve first parameter
lcParameter=UPPER(THIS.oRequest.Querystring(1))  

*** Set up project types and call external processing programs:
DO CASE

     CASE lcParameter == "MLPROCESS"
         DO MLProcess with THIS

      *** SUB APPLETS ADDED ABOVE - DO NOT MOVE THIS LINE ***

	  CASE lcParameter == "WWMAINT"
	      DO wwMaint with  THIS
  OTHERWISE
     *** Check for Script Mapped files for: .WC, .WCS, .FXP
     lcExtension = Upper( JustExt(THIS.oRequest.GetPhysicalPath() ) )
     
     DO CASE

     CASE lcExtension == "AFUG"
        DO MLProcess with THIS

     *** ADD SCRIPTMAP EXTENSIONS ABOVE - DO NOT MOVE THIS LINE ***

     *** Default Web Connection script handling
     CASE lcExtension = "WC" OR lcExtension == "FXP"
        DO wwScriptMaps with THIS
     
     *** Web Connection SOAP/Web Service Handler
     CASE lcExtension == "WWSOAP"
        DO wwDefaultWebService with THIS

     OTHERWISE
         *** Error - No handler available. Create custom 
	     Response=CREATE([WWC_RESPONSESTRING])
	     Response.StandardPage("Unhandled Request",;
	                       "The server is not setup to handle this type of Request: "+lcParameter)

	     IF THIS.oConfig.lAdminSendErrorEmail
	       LOCAL loIP
           loIP = CREATE("wwIPStuff")
		   loIP.cMailServer = THIS.oConfig.cAdminMailServer
		   loIP.cSenderEmail = THIS.oConfig.cAdminEmail
		   loIP.cRecipient = THIS.oConfig.cAdminEmail
		   loIP.cSubject = "Web Connection Error Message - Unhandled request"
		   loIP.cMessage = CRLF + ;
	           "The request Query String is: " +THIS.oRequest.QueryString() + CRLF +;
	           "              DLL or Script: " +THIS.oRequest.ServerVariables("Executable Path") + CRLF+;
	           "                Server Name: " + THIS.oRequest.GetServerName() + CRLF + ;
	           "                 IP Address: " + THIS.oRequest.GetIPAddress()
   
           *** Send and immediately return
           loIP.SendMailAsync()
         ENDIF

	     IF THIS.lCOMObject
	         *** Simply assign to output property
	         THIS.cOutput=Response.GetOutput()
	     ELSE
	         *** FileBased - must output to file
	         File2Var(THIS.oRequest.GetOutputFile(),Response.GetOutput())
	     ENDIF
	 ENDCASE
   
ENDCASE

RETURN

ENDDEFINE
* EOC Memberlistapp



************************************************************************
PROCEDURE ErrorHandler
**********************
***  Modified: 12/31/95
***  Function: Global Error handler. Shuts down everything then
***            restarts the server from scratch. Used to make sure the
***            server is always running. This error handler will write
***            an error to the log, but won't output an HTML document.
***
***            Note that local error handlers in the Process class
***            or other classes will override the global handler.
*************************************************************************
PARAMETER t_errorno,t_mess1,t_mess2,t_module,t_lineno
LOCAL llOldLogging, lcProcess, lcOldError

lcOldError = ON("ERROR")

*** Further errors should be ignored here
ON ERROR *

IF TYPE("goWCServer")="O"
   IF TYPE("goWCServer.oRequest")="O"  
      lcProcess= CR+goWCServer.oRequest.QueryString()+CR+CR
   ELSE
      lcProcess=""
   ENDIF

   goWCServer.LogRequest("Processing Error<br>"+CR+;
                       lcProcess+CR+;
                       "<PRE>"+CR+;
                       "Error: "+STR(T_errorno)+CR+;
                       "Message: "+T_Mess1+CR+;
                       "Code: "+T_mess2+CR+;
                       "Program: "+T_Module+CR+;
                       "Line No: "+STR(T_lineno)+CR+"</PRE>",;
                       "Local",0,.t.)
  
ENDIF

CLOSE DATA

* RELEASE WINDOWS  && Release CGI Server Window and moves code on

ON ERROR &lcOldError

*** Restart - ie. hit the main loop
RETURN TO MASTER


************************************************************************
PROCEDURE Shutit
******************
***  Function: System Shutdown Procedure
*************************************************************************
ON ERROR *
RELEASE goWCServer
ON SHUTDOWN
QUIT
RETURN


***************************************************************
DEFINE CLASS MemberlistappConfig AS wwServerConfig
***************************************************************
*: Author: Rick Strahl
*:         (c) West Wind Technologies, 1999
*:Contact: http://www.west-wind.com
*******&&******************************************************
#IF .F.
*:Help Documentation
*:Topic:
Class Memberlistapp 

*:Description:
This class is used as a global configuration object to 
contain application global data that persists for the
lifetime of the server. 

Optionally you can have sub-application objects for each
Process class implementation.
*:ENDHELP
#ENDIF
****************************************************************

oMLProcess = .NULL.

*** ADD CONFIG OBJECT TO CLASS ABOVE - DO NOT MOVE THIS LINE ***
owwMaint = .NULL.

FUNCTION Init

THIS.oMLProcess = CREATEOBJECT("MLProcessConfig")

*** ADD CONFIG INIT CODE ABOVE - DO NOT MOVE THIS LINE ***

THIS.owwMaint = CREATEOBJECT("wwMaintConfig")

ENDFUNC

ENDDEFINE
*EOC MemberlistappConfig


DEFINE CLASS wwMaintConfig as RELATION

cHTMLPagePath = "C:\wwwroot\MemberListApp\"
cDATAPath = ".\"
cVirtualPath = "/MemberListApp/"

ENDDEFINE



*** Configuration class for the MLProcess Process class
DEFINE CLASS MLProcessConfig as wwConfig

cHTMLPagePath = "C:\wwwroot\MemberListApp\"
cDATAPath = ""

ENDDEFINE

*** ADD PROCESS CONFIG CLASSES ABOVE - DO NOT MOVE THIS LINE ***




