************************************************************************
*PROCEDURE MLProcess
****************************
***  Function: Processes incoming Web Requests for MLProcess
***            requests. This function is called from the wwServer 
***            process.
***      Pass: loServer -   wwServer object reference
*************************************************************************
LPARAMETER loServer
LOCAL loProcess
#INCLUDE WCONNECT.H

loProcess=CREATE("MLProcess",loServer)
loProcess.lShowRequestData = loServer.lShowRequestData

IF VARTYPE(loProcess)#"O"
   *** All we can do is return...
   WAIT WINDOW NOWAIT "Unable to create Process object..."
   RETURN .F.
ENDIF

*** Call the Process Method that handles the request
loProcess.Process()

RETURN

*************************************************************
DEFINE CLASS MLProcess AS WWC_PROCESS
*************************************************************

	cSessionID = []
	cAppName = [AFUG]

*********************************************************************
* Function MLProcess :: Process
************************************
*** If you need to hook up generic functionality that occurs on
*** every hit, implement this method then call DoDefault() to
*** get the default Request Processing functionality. See docs
*** for more info on how to customize wwProcess::Process behavior.
*********************************************************************
FUNCTION Process

	THIS.cSessionID = THIS.oRequest.GetCookie(THIS.cAppName)
	loSession= CREATEOBJECT("wwSession")
	IF loSession.IsValidSession(THIS.cSessionID)
		DODEFAULT()
	ELSE
		loSession.EndSession(THIS.cSessionID)
		IF NOT THIS.Login()
			RETURN .F.
		ENDIF
	ENDIF
RETURN .T.
ENDFUNC

*********************************************************************
FUNCTION Login
PARAMETER pcMessage, lcUserID, lcPWD
LOCAL lcCidClient

	Request = goWCServer.oRequest
	Response = THIS.oResponse
	pcTitle = goWCServer.cAppName
	IF VARTYPE(pcMessage)#"C"
		RELEASE pcMessage
		pcMessage = []
	ENDIF

	IF VARTYPE(lcUserID) = "C" AND VARTYPE(lcUserPWD) = "C" 
		* The values were passed in, lets use them.
		lcUserID 	= ALLTRIM(UPPER(lcUserid))
		lcPWD 	= ALLTRIM(UPPER(lcPWD))
	ELSE
		lcProcedure = UPPER(Request.Querystring(2))
		IF lcProcedure # [LOGIN]
			* The users session most likely timed out.  Don't use any additional parameters. - KJC
			STORE [] TO lcUserID, lcPWD
		ENDIF
	ENDIF
	IF EMPTY(lcUserID) AND EMPTY(lcPWD)
		lcUserID 	= ALLTRIM(UPPER(Request.Form([txtuserid])))
		lcPWD 	= ALLTRIM(UPPER(Request.Form([txtpwd])))
	ENDIF
	
	IF VARTYPE(lcUserID) = "C" AND VARTYPE(lcPWD) = "C"

		*** If the userid and pwd is passed in, then go ahead and check for valid user.
		*** This site, if using this method, should definitely use HTTPS. - KJC
		IF NOT EMPTY(lcPWD)
			IF goWCServer.oMember.QueryUserByIDAndPassword('c_User', lcUserID, lcPWD) > 0
				loSession.NewSession(lcUserID, THIS.cSessionID)
				THIS.QueryMembers()
				RETURN .T.
			ENDIF
		ENDIF
	ENDIF

	*** This deals with the ability to set focus.
	DO CASE
		CASE EMPTY(lcUserID)
			lcFocus = [txtuserid]
		CASE EMPTY(lcPWD)
			lcFocus = [txtpwd]
		OTHERWISE
			lcFocus = [txtuserid]
	ENDCASE	

	lcSessionID=SUBSTR(SYS(2015),2,9)

	loHeader=CREATE("wwHTTPHeader")
	loHeader.Defaultheader()

	loHeader.AddCookie(This.cAppName, lcSessionID)
	Response.clear()
	Response.ContentTypeHeader(loHeader)

	lcTemplate = File2Var("HTML\Login.HTM")
	lcExpandedhtml = Response.ExpandTemplate(lcTemplate,[],.t.,.t.)
	response.write(lcExpandedHTML)
RETURN .F.

ENDFUNC

*********************************************************************
FUNCTION QueryMembers
	PRIVATE loRequestVars AS Object
	WITH goWCServer.oMember
		.GetBlankRecord()
		loRequestVars = Request.FormVarsToObject( .oData )
		lcOrder = Request.Form("txtOrder")
		lcOutput = UPPER(Request.Form("cboOutput"))
		.QueryByParameters('c_Member', loRequestVars.m_FName, loRequestVars.m_LName, lcOrder)
		
		DO CASE
			CASE lcOutput = "HTML" OR EMPTY(lcOutput)
				THIS.OutputAsHTML("c_Member")
			CASE lcOutput = "XML"
				THIS.OutputAsXML("c_Member")
			CASE lcOutput = "EXCEL"
				THIS.OutputAsExcel("c_Member")
			CASE lcOutput = "PDF"
				THIS.OutputAsPDF("c_Member")
		ENDCASE
	ENDWITH
ENDFUNC

**********************************************************************
FUNCTION OutputAsHTML
LPARAMETERS tcCursor

	IF USED(tcCursor)
		loShowCursor = CREATEOBJECT("wwShowCursor")
		WITH loShowCursor
			.cBaseURL = "MemberEdit.afug?"
			.cKeyField = "PK"
			.cKeyType = "N"
			.lAllowAdd = .T.
			.lAllowDelete = .T.
			.lAlternateRows = .T.
		ENDWITH
		
		SELECT (tcCursor)
		IF loShowCursor.EditTable()
			lcCursor = loShowCursor.GetOutput()
			lcTemplate = File2Var("HTML\MemberList.htm")
			lcExpandedHTML = Response.ExpandTemplate(lcTemplate, [], .T., .t.)
			Response.Write(lcExpandedHTML)
		ELSE
			THIS.StandardPage("Could not create list from cursor.", PROGRAM())
		ENDIF
	ENDIF
ENDFUNC

**********************************************************************
FUNCTION OutputAsXML
LPARAMETERS tcCursor

	IF USED(tcCursor)
		loXML = CREATEOBJECT("wwXML")
		loXML.nCreateDataStructure = 1
		lcXML = loXML.CursorToXML()
		Response.Write(lcXML)
	ELSE
		THIS.StandardPage("Something has gone horribly, horribly wrong.")
	ENDIF
ENDFUNC

**********************************************************************
FUNCTION OutputAsExcel
LPARAMETERS tcCursor

	IF USED(tcCursor)
		lcRelativePath = [output\] + DTOC(DATE(),1) + SYS(2015) + [.xls]
		lcOutputFile = goWCServer.oConfig.oMLProcess.cHTMLPagePath + lcRelativePath
		COPY TO (lcOutputFile) TYPE XL5
		THIS.StandardPage("Here is your Excel file.", ;
			[<a href="] + lcRelativePath + [">] + [Click here to open your Excel document.] + [</a>])
	ELSE
		THIS.StandardPage("Somethings wrong.")
	ENDIF
ENDFUNC

**********************************************************************
FUNCTION OutputAsPDF
LPARAMETERS tcCursor

	IF USED(tcCursor)
		lcRelativePath = [output\] + DTOC(DATE(),1) + SYS(2015) + [.pdf]
		lcOutputFile = goWCServer.oConfig.oMLProcess.cHTMLPagePath + lcRelativePath

		loPDF = CREATEOBJECT("wwPDF40")
		loPDF.PrintReport("rpt\rptMemberList.frx", lcOutputFile)
		IF EMPTY(loPDF.cErrorMsg)
			THIS.StandardPage("Here is your PDF document", ;
				[<a href="]+ lcRelativePath + [">Click here to open your PDF document.</a>]) 
		ELSE
			THIS.StandardPage("There was an error!", [... and here it is:] + loPDF.cErrorMsg)
		ENDIF
	ELSE
		THIS.StandardPage("Somethings wrong.")
	ENDIF
ENDFUNC

**********************************************************************
FUNCTION MemberEdit

	lcAction = UPPER( Request.QueryString("Action"))
	IF EMPTY(lcAction)
		lcAction = UPPER(Request.Form( "btnAction" ))
	ENDIF
	lnMemberPK = INT(VAL(ALLTRIM(Request.QueryString("ID"))))
	
	DO CASE
		CASE lcAction = "QUERY"
			THIS.QueryMembers()
		CASE lcAction = "DELETE"
			goWCServer.oMember.oData.PK = lnMemberPK
			goWCServer.oMember.Delete()
			THIS.StandardPage("The member record was deleted.", ;
				[<a href="QueryMembers.afug">Return to the Query Page</a>])
		OTHERWISE
			DO CASE
				CASE lcAction = "ADD"
					lnMemberPK = goWCServer.oMember.CreateNewID()
					goWCServer.oMember.QueryByParameters('c_Member', [],[],[])
					lcMessage = [New Record]
				OTHERWISE
					IF goWCServer.oMember.Load(lnMemberPK)
						IF lcAction = "SAVE"
							goWCServer.oMember.oData = ;
								Request.FormVarsToObject(goWCServer.oMember.oData)
							goWCServer.oMember.Save()
							lcMessage = [Record Saved at ] + TIME()
						ELSE
							lcMessage = []
						ENDIF
					ELSE
						THIS.ErrorMsg("No member number to edit.", ;
							"Please enter a member ID to edit.")
					ENDIF
			ENDCASE
			loMember = goWCServer.oMember.oData
			** Display our record
			loShowCursor = CREATEOBJECT("wwShowCursor")
			WITH loShowCursor
				.EditRecord()
				lcTable = .GetOutput()
				lcTemplate = File2Var('HTML\MemberEdit.htm')
				lcExpandedHTML = Response.ExpandTemplate(lcTemplate, [], .T., .T.)
				Response.Write(lcExpandedHTML)
			ENDWITH
	ENDCASE
	
ENDFUNC






*********************************************************************
FUNCTION HelloWorld()
************************

THIS.StandardPage("Hello World from the MLProcess process",;
                  "If you got here, everything should be working fine.<p>" + ;
                  "Time: <b>" + TIME()+ "</b>")
                  
ENDFUNC
* EOF MLProcess::HelloWorld


*** Recommend you override the following methods:

*** ErrorMsg
*** StandardPage
*** Error

ENDDEFINE