CLOSE ALL
CLEAR ALL

SET SAFETY OFF
SET PROCEDURE TO FoxToTeX ADDITIVE

LOCAL loTex, lcEquation, lnStartTime, lnEndTime, lnTimeSpent, lcCaption, lcCaption1, lcLabel, lcLabel1

? TIME(), PROGRAM(), REPLICATE("=", 50)
lnStartTime = SECONDS()
loTex = CREATEOBJECT("FoxToTeX")

WITH loTex
	? TIME(), PROGRAM(), [FoxToTeX Version], .Version()
	.cOutputFile		= PROGRAM() + [_] + DTOC(DATE(),1) + [.tex]
	IF .OutputFileNotInUse()
		.cDocumentClass 	= [book]
		.cDocumentName 		= PROGRAM()

		.cOptionFontSize 	= [12pt]
		.cOptionPaperSize 	= [letterpaper]
		.cOptionPageFormat 	= [onecolumn]

		.cTitle 			= PROGRAM()
		.cAuthor 			= [CULLY Technologies, LLC]
		.dDate 				= DATE()

		.cDocument = []
		.cDocument = .cDocument + .TexFrontMatter()

		lcGraphic1 = [images/berberis3.jpg]
		lcScale = [width=2in]
		lcCaption1 = [Barberry]
		lcLabel1 = [Lots of thorns on this one!]
		.cDocument = .cDocument + .TexFigure(lcGraphic1, lcScale, lcCaption1, lcLabel1)
		
		lcGraphic2 = [images/irispseudacorusyellowflagclose.jpg]
		lcScale = [width=1.5in]
		lcCaption = [Yellow flagclose]
		lcLabel = [Brings color to the garden!]
		.cDocument = .cDocument + .TexFigure(lcGraphic2, lcScale, lcCaption, lcLabel)

		lcGraphic3 = [images/Prunuslaurocerasus1.jpg]	
		.cDocument = .cDocument + .TeXPageBreak()
		.cDocument = .cDocument + .TeXIncludeGraphics(lcGraphic1, lcScale)
		.cDocument = .cDocument + .TeXIncludeGraphics(lcGraphic2, lcScale)
		.cDocument = .cDocument + .TeXIncludeGraphics(lcGraphic3, lcScale) + .CRLF

		&& We're making a reference to an item on a previous page.
		.cDocument = .cDocument + [See similar reference to figure ] + .TeXReferencePage(lcLabel1)		

		.cDocument = .cDocument + .TexBackMatter()
		.cDocument = .TexInsertPackages(.cDocument)
		.TexOutput()
		.TexToPDF()
	ELSE
		? TIME(), PROGRAM(), "The output file of " + .cOutputFile + " is in use so we cannot proceed."
	ENDIF
ENDWITH
lnEndTime = SECONDS()
lnTimeSpent = lnEndTime - lnStartTime
? TIME(), PROGRAM(), [Time spent:], lnTimeSpent, [seconds]
? TIME(), PROGRAM(), REPLICATE("=", 50)
