CLOSE ALL
CLEAR ALL

** Reference: http://www.tug.org/tutorials.html  (Chapter 11, Mathematics)

*** NOTE:
*** 	In this example, we're also generating an index.
***	Because of the index, we actually need to run through
*** the TeX file in multiple steps:
***		(1) Run "PDFLATEX {Output File}"  				&& This program already calls PDFLATEX for you.
***		(2) Run "MAKEINDEX {Output Stem File Name}"  	&& Notice that no extension should be included here. It'll give a really cryptic error message.
***		(3) Run "PDFLATEX {Output File}" 				&& This includes the index information into the PDF file for you!
***	Now you're set to enjoy your VFP and TeX generated file!

SET SAFETY OFF
SET PROCEDURE TO FoxToTeX ADDITIVE

LOCAL loTex, lcEquation, lnStartTime, lnEndTime, lnTimeSpent

? TIME(), PROGRAM(), REPLICATE("=", 50)
lnStartTime = SECONDS()
loTex = CREATEOBJECT("FoxToTex")

WITH loTex
	.cOutputFile		= PROGRAM() + [_] + DTOC(DATE(),1) + [.tex]
	IF .OutputFileNotInUse()
		.cDocumentClass 	= [book]
		.cDocumentName 		= PROGRAM()
		
		.cOptionFontSize 	= [12pt]
		.cOptionPaperSize 	= [letterpaper]
		.cOptionPageFormat 	= [onecolumn]
		
		.cTitle 			= PROGRAM()
		.cAuthor 			= [CULLY Technologies, LLC]
		.dDate 				= DATE()
		
		.cBiblioCursor		= [c_Biblio]
		.cBiblioField		= [cBibEntry]
		
		.cDocument = []	
		.cDocument = .cDocument + .TexFrontMatter()
		
		.cDocument = .cDocument + .TexSection("Here is an equation example:", "")
		
		lcEquation = [\varphi(x,z) = z - \gamma_{10} x - \sum_{m+n\ge2} \gamma{mn} x^m z^n]
		.cDocument = .cDocument + .TexEquation(lcEquation)
		.cDocument = .cDocument + .TeXIndexItem("Equation Example")
		.cDocument = .cDocument + .TexPageBreak()
		
		.cDocument = .cDocument + .TexSection("Here is an 'Display Math' example:", "")

		lcEquation = [\left(\int_{-\infty}^{\infty} e^{-x^2}\right)] + ;
					[=\int_{-\infty}^{\infty}\int_{-\infty}^{\infty}e^{-(x^2+y^2)}dx\,dy]
		.cDocument = .cDocument + .TexDisplayMath(lcEquation)
		.cDocument = .cDocument + .TeXIndexItem("Display Math Example")
		.cDocument = .cDocument + .TexPageBreak()
		
		.cDocument = .cDocument + .TexBackMatter()
		
		.cDocument = .TeXInsertPackages(.cDocument)
		
		.TeXOutput()
		.TeXToPDF()
	ELSE
		? TIME(), PROGRAM(), "The output file " + FORCEEXT(.cOutputFile,'PDF') + " is in use probably with the Adobe Acrobat Reader."
	ENDIF
ENDWITH
lnEndTime = SECONDS()
lnTimeSpent = lnEndTime - lnStartTime
? TIME(), PROGRAM(), [Time spent:], lnTimeSpent, [seconds]
? TIME(), PROGRAM(), REPLICATE("=", 50)
