CLOSE ALL
CLEAR ALL

*** NOTE:
***	Now you're set to enjoy your VFP and TeX generated file!

SET SAFETY OFF
SET PROCEDURE TO FoxToTeX ADDITIVE

LOCAL loTex, lcEquation, lnStartTime, lnEndTime, lnTimeSpent

? TIME(), PROGRAM(), REPLICATE("=", 50)
lnStartTime = SECONDS()
loTex = CREATEOBJECT("FoxToTex")


WITH loTex
	.cOutputFile		= PROGRAM() + [_] + DTOC(DATE(),1) + [.tex]
	IF FILE(.cOutputFile)
		DELETE FILE (.cOutputFile)
	ENDIF
	
	IF .OutputFileNotInUse()		&& Just to make sure...
		.cDocumentClass 	= [article]
		.cDocumentName 		= PROGRAM()
		
		.cOptionFontSize 	= [12pt]
		.cOptionPaperSize 	= [letterpaper]
		.cOptionPageFormat 	= [onecolumn]
		
		.cTitle 			= PROGRAM()
		.cAuthor 			= [CULLY Technologies, LLC]
		.dDate 				= DATE()
		
		.cDocument = []	
		.cDocument = .cDocument + .TeXDocumentClass()
		.cDocument = .cDocument + .TeXPackagePlaceholder()		&& Used with TeXInsertPackages
		.cDocument = .cDocument + .TexBegin()

		lnFileCount = ADIR(laPDFList, '*.PDF')
		FOR lnX = 1 TO lnFileCount
			lcFileName = laPDFList(lnX, 1)			
			IF .OutputFileNotInUse(lcFileName)
				? TIME(), PROGRAM(), "Including PDF file: " + lcFileName
				.cDocument = .cDocument + .TeXIncludePDF(JUSTSTEM(lcFileName))
				.cDocument = .cDocument + .TexPageBreak()
			ELSE
				? TIME(), PROGRAM(), "Could not include the pdf file because it is in use:", lcFileName
			ENDIF
		ENDFOR		
		
		.cDocument = .cDocument + .TexEnd()
		
		.cDocument = .TeXInsertPackages(.cDocument)
		
		.TeXOutput()
		.TeXToPDF()
	ELSE
		? TIME(), PROGRAM(), "The output file " + FORCEEXT(.cOutputFile,'PDF') + " is in use probably with the Adobe Acrobat Reader."
	ENDIF
ENDWITH
lnEndTime = SECONDS()
lnTimeSpent = lnEndTime - lnStartTime
? TIME(), PROGRAM(), [Time spent:], lnTimeSpent, [seconds]
? TIME(), PROGRAM(), REPLICATE("=", 50)
